#include "c4d_basekey.h"
#include "c4d_basesequence.h"
#include "c4d_basetrack.h"
#include "c4d_baseobject.h"

BaseList2D *BaseSequence::GetObject(void)
{
	BaseTrack *bs=GetTrack();
	if (bs) return bs->GetObject(); else return NULL;
}

void BaseSequence::SetT1(const BaseTime &time)
{
	C4DOS.Bq->SetT1(this,time);
}

BaseTime BaseSequence::GetT1(void)
{
	return C4DOS.Bq->GetT1(this);
}

void BaseSequence::SetT2(const BaseTime &time)
{
	C4DOS.Bq->SetT2(this,time);
}

BaseTime BaseSequence::GetT2(void)
{
	return C4DOS.Bq->GetT2(this);
}

void BaseSequence::SetT3(const BaseTime &time)
{
	C4DOS.Bq->SetT3(this,time);
}

BaseTime BaseSequence::GetT3(void)
{
	return C4DOS.Bq->GetT3(this);
}

void BaseSequence::SetSoft(Bool b)
{
	C4DOS.Bq->SetSoft(this,b);
}

Bool BaseSequence::GetSoft(void)
{
	return C4DOS.Bq->GetSoft(this);
}

void BaseSequence::SetLeftInfluence(Bool b)
{
	C4DOS.Bq->SetLeftInfluence(this,b);
}

Bool BaseSequence::GetLeftInfluence(void)
{
	return C4DOS.Bq->GetLeftInfluence(this);
}

void BaseSequence::SetRightInfluence(Bool b)
{
	C4DOS.Bq->SetRightInfluence(this,b);
}

Bool BaseSequence::GetRightInfluence(void)
{
	return C4DOS.Bq->GetRightInfluence(this);
}

void BaseSequence::FlushAllKeys(void)
{
	C4DOS.Bq->FlushAllKeys(this);
}

LONG BaseSequence::GetKeyCount(void)
{
	return C4DOS.Bq->GetKeyCount(this);
}

BaseKey	*BaseSequence::FindKey(const BaseTime &time)
{
	return C4DOS.Bq->FindKey(this,time);
}

BaseTime BaseSequence::GetLeft(void)
{
	return C4DOS.Bq->GetLeft(this);
}

BaseTime BaseSequence::GetRight(void)
{
	return C4DOS.Bq->GetRight(this);
}

BaseKey *BaseSequence::GetFirstKey(void)
{
	return C4DOS.Bq->GetFirstKey(this);
}

Bool BaseSequence::InsertKey(BaseKey *bk)
{
	return C4DOS.Bq->InsertKey(this,bk);
}

BaseSound *SoundSequence::GetSound(void) 
{ 
	return C4DOS.Bq->GetSound(this);
}

void SoundSequence::SetSound(BaseSound *bs) 
{ 
	C4DOS.Bq->SetSound(this,bs);
}

BaseSequence* BaseSequence::Alloc(LONG type)
{
	return C4DOS.Bq->Alloc(type,0);
}

void BaseSequence::Free(BaseSequence *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

PluginSequence* PluginSequence::Alloc(LONG type)
{
	return (PluginSequence*)C4DOS.Bq->Alloc(type,0);
}

void PluginSequence::Free(PluginSequence *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

SoundSequence* SoundSequence::Alloc()
{
	return (SoundSequence*)C4DOS.Bq->Alloc(Ssound,0);
}

void SoundSequence::Free(SoundSequence *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}
